<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;
use \Illuminate\Support\Str;


class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $text = 'Education,Class 1 to 5,Metric,
,Class 5 to 10,CBSE,
,Class 11 & 12,ICSE,
,,State,
,,Others,
,NEET,,
,JEE,,
,CLAT,,
,NATA,,
,NDA,,
,Polytechnic Diploma,DCSE,
,,DCE,
,,DME,
,,DECE,
,,DEE,
,,D in Interior,
,,D in Fashion,
,,Others,
,Engineering,BE CSE,
,,BE Mech,
,,BE ECE,
,,BE Elect,
,,BE EEE,
,,BE Civil,
,,Others,
,Arts & Science,BA,
,,BBA,
,,BALLB,
,,BFA,
,,BFD,
,,BHM,
,,B. Sc,
,,B. Com,
,MBA,Marketing,
,,International Business,
,,Finance,
,,Human Resource,
,,Operations,
,,Hospitality,
,,Retail,
,,Hotel,
,,Supply Chain,
,Fine Arts & Crafts,Drawing,
,,Origami,
,,Sculpture,
,,Calligraphy,
,,Photography,
,,Pottery,
,,Digital Art,
,Medical,MBBS,
,,MS,
,,MD,
,,BDS,
,,BAMS,
,,BHMS,
,,BPT,
,,B. Vsc,
,,BUMS,
,,BSMS,
,,BNYS,
,Religious,SrimadBagavatham,
,,Ramayanam,
,,Narayaneeyam,
,,MulamBagavatham,
,,Devi Bagavatham,
,,Bagavathgeetha,
,,Vishnusahasranamam,
,,LalithaSahasranamam,
,,Upanishads,
,,ZnaganaPana,
,,HariNamaKeerthanam,
,,Silapathikaram,
,,Thirukural,
,,Manimegalai,
Music Vocal,Carnatic,,
,Hindustani,,
,Western,,
,PlayBack Singing,,
,Folk,,
,RAP,,
Music Instruments,Violin,,
,Veena,,
,Guitar,,
,Sitar,,
,Shenoy,,
,Keyboard,,
,Piano,,
,Saxaphone,,
,Mirudhangam,,
,Tabala,,
,Drums,,
,Chenda,,
,Madhalam,,
,Kombu,,
,Edika,,
,Thappu,,
,Pamba,,
Dance,Baradhanattiyam,,
,MohiniAttam,,
,Kuchupudi,,
,Kadhak,,
,Kadhakali,,
,Balley Dance,,
,Break,,
,Cinematic,,
Cooking,South Indian,,
,North Indian,,
,Baking,,
,Chinese,,
,Thai,,
,Sweets,,
,Namkeen,,
,Snacks,,
Doctor,Orthopedics,,
,General medicine,,
,Obstetrics and Gynaecology,,
,Dermatology,,
,Paediatric,,
,Radiology,,
,General Surgery,,
,Ophthalmology,,
,ENT,,
,Gastro,,
,Urology,,
,Oncology,,
Legal / Advocate,Criminal,,
,Civil,,
,Taxation,,
,Family,,
,Media,,
,Human Rights,,
,Corporate / Company,,
,Labour,,
,Banking / Finance,,
,Forex,,
,Intellectual Property,,
,Cyber,,
,Consumer,,
Beauty & Personal Care,Beautician Course,,
,Massaging Course,,
,Diet Management,,
,Gym Training,,
,Zumba,,
,Erubics,,
,Yoga,,
,Meditation,,
Consulting,Industry 4.0,,
,Operations,,
,SCM,,
,LCA,,
,Factory Automation,,
,BPA,,
,Productivity,,
,Bottomline,,
,Greenfield Setup,,
Branded Stores,Home Appliances,,
,Mobile,,
,Furniture,,
,Home Decors,,
,Handicrafts,,
,Home made,,
,Home Automation,,
,Lighting & LED,,
Entertainment,Stand-up Comedy,,
,DJ - Mixing,,
,Story Telling,,
Astrology,NadiJodhidam,,
,Numerology,,
,Vasthu,,
,ThambulaJodhidam,,
,AstamangalaJodhidam,,
,Deva Prashnam,,
,KavadiJodhidam,,
,Porutham&Muhurtham,,
RealEstate,House Rental,,
,House Sale,,
,Land Sale,,
,Shop Rental,,
,Commercial Complex Rental,,
Used Goods,,,
Auction,,,
Private,Listening,,
,Punch Bag,,
,Chat Service,,
Insurance,Health,,
,Home,,
,Motor,,
,Fire,,
,Travel,,
,Life,,
Architect,Interior Design,,
,Residential,,
,Commercial,,
,Landscaping,,
,Green Design,,
Investment Services,Mutual Investment,,
,Stock Market,,
,Bonds,,
,Exchange Trade,,
,Fixed Deposit,,
,Retirement Planning,,';

        // csv data get row by row
        $rows = explode("\r\n", $text);
        if (count($rows) < 10) {
            $rows =  explode("\n", $text);
        }

        $dataList = [];
        foreach ($rows as $row) {
            $cols = explode(",", $row);
            $category = $cols[0];
            $sub_category = $cols[1];
            $sub_sub_category = $cols[2];
            $appointment_booking_days = $cols[3];
            $dataList[] = [
                'category' => $category,
                'sub_category' => $sub_category,
                'sub_sub_category' => $sub_sub_category
            ];
        }


        // subcategory  ask key and sub_sub_category as value
        $subcategory = [];
        $prevSubc = "";
        foreach ($dataList as $key => $value) {

            if ($value['sub_category'] == "") {
                $subcategory[$prevSubc][] = $value['sub_sub_category'];
            } else {
                $subcategory[$value['sub_category']][] = $value['sub_sub_category'];
                $prevSubc = $value['sub_category'];
            }
        }


        //loop datalist and get category and subcategory
        // if subcategory is empty then add subcategory to list
        $prevCat = "";
        $catList = [];
        foreach ($dataList as $key => $value) {

            if ($value['category'] == "") {
                if ($value['sub_category'] != "") {
                    $d = [
                        "name" => $value['sub_category'],
                        "children" => $subcategory[$value['sub_category']] ?? []
                    ];
                    $catList[$prevCat][] = $d;
                }
            } else {
                $prevCat = $value['category'];
                if ($value['sub_category'] != "") {

                    $d = [
                        "name" => $value['sub_category'],
                        "children" => $subcategory[$value['sub_category']] ?? []
                    ];

                    $catList[$value['category']][] = $d;
                }
            }
        }


        // insert $catList to database

        //loop catList and insert category
        // echo print_r($rows);
        //  exit;
        foreach ($catList as $key => $value) {
            //echo $key;
            $category = trim($key);
            $sub_category = $value;
            // insert category
            if (trim($category) == "") {
                continue;
            };
            $cat = \App\Models\Category::create([
                'category_name' => $category,
                'category_slug' => Str::slug($category),
                'category_status' => 'Active',
                'category_order' => 0,
            ]);

            //loop sub_category and insert subcategory
            if (count($sub_category) > 0) {
                foreach ($sub_category as $subc) {
                    $sub_category = trim($subc['name']);
                    $sub_sub_category = $subc['children'];
                    // insert subcategory
                    if (trim($sub_category) == "") {
                        continue;
                    }
                    $subcat = \App\Models\Category::create([
                        'category_parent' => $cat->id,
                        'category_name' => $sub_category,
                        'category_slug' => Str::slug($cat->category_name . "_" . $sub_category),
                        'category_status' => 'Active',
                        'category_order' => 0,
                    ]);

                    //if sub_sub_category is not empty then insert sub_sub_category
                    if (count($sub_sub_category) > 0) {
                        foreach ($sub_sub_category as $sub_sub) {
                            $sub_sub_category = trim($sub_sub);
                            // insert sub_sub_category
                            if (trim($sub_sub_category) == "") {
                                continue;
                            }
                            $sub_subcat = \App\Models\Category::create([
                                'category_parent' => $subcat->id,
                                'category_name' =>  $sub_sub_category,
                                'category_slug' => Str::slug($cat->category_name . "_" . $subcat->category_name . "_" . $sub_sub_category),
                                'category_status' => 'Active',
                                'category_order' => 0,
                            ]);
                        }
                    }
                }
            }
        }
    }
}
