<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateScheduleCalendarRequests extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('schedule_calendar_requests', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_bookings_id')->nullable();
            $table->unsignedBigInteger('service_provider_id')->nullable();
            $table->unsignedBigInteger('customer_id')->nullable();
            $table->string('service_type')->nullable();
            $table->unsignedBigInteger('schedule_id')->nullable();
            $table->date('date')->nullable();
            $table->time('start_time')->nullable();
            $table->time('end_time')->nullable();
            $table->string('status')->nullable();
            $table->string('request_type')->nullable();
            $table->string('requested_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('schedule_calendar_requests');
    }
}
