<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOpenCalendarSchedules extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('open_calendar_schedules', function (Blueprint $table) {
            $table->id();
            $table->integer('calendar_service_id');
            $table->integer('open_calendar_id');
            $table->integer('user_id');

            $table->integer('time_per_session')->nullable();

            // type audio=1, video=2
            $table->integer('type')->default(1);

            // price
            $table->decimal('price', 10, 2)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('open_calendar_schedules');
    }
}
