<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOpenServicecalendar extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('open_calendar', function (Blueprint $table) {
            $table->id();
            $table->integer('calendar_service_id');
            $table->integer('user_id');
            // start time time
            $table->time('start_time')->nullable();
            // end time time
            $table->time('end_time')->nullable();
            // paid by self or paid by client
            $table->integer('paid_by')->default(1);
            // allow booking afer x days
            $table->integer('allow_booking_after')->default(0);
            // calendar visibility. city=1, state=2, global=3 and invite=4
            $table->integer('calendar_visibility')->default(1);
            // calendar_visibility_users list json
            $table->json('calendar_visibility_users')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('open_servicecalendar');
    }
}
