<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterServiceSchedule extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::table('service_schedules', function (Blueprint $table) {
            $table->integer('time_per_session')->nullable()->after('schedule_name');
            $table->integer('gap_between_sessions')->nullable()->after('time_per_session');
            $table->integer('number_of_sessions')->nullable()->after('gap_between_sessions');
            $table->integer('clients_per_session')->nullable()->after('number_of_sessions');
            //session_start_time time
            $table->time('schedule_start_time')->nullable()->after('clients_per_session');
            //session_end_time time
            $table->time('schedule_end_time')->nullable()->after('schedule_start_time');

            // calendar visibility. city=1, state=2, global=3 and invite=4
            $table->integer('calendar_visibility')->default(1)->after('schedule_end_time');

            // calendar_visibility_users list json
            $table->json('calendar_visibility_users')->nullable()->after('calendar_visibility');

            // charges_per_session 
            $table->decimal('charges_per_session', 10, 2)->nullable()->after('calendar_visibility_users');

            // paid by self or paid by client
            $table->integer('paid_by')->default(1)->after('charges_per_session');

            // charges per appointment or charges per session
            $table->integer('charges_per')->default(1)->after('paid_by');

            // allow booking afer x days
            $table->integer('allow_booking_after')->default(0)->after('charges_per');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('service_schedules', function (Blueprint $table) {
            $table->dropColumn('time_per_session');
            $table->dropColumn('gap_between_sessions');
            $table->dropColumn('number_of_sessions');
            $table->dropColumn('clients_per_session');
            $table->dropColumn('session_start_time');
            $table->dropColumn('session_end_time');
            $table->dropColumn('calendar_visibility');
            $table->dropColumn('calendar_visibility_users');
            $table->dropColumn('charges_per_session');
            $table->dropColumn('paid_by');
            $table->dropColumn('charges_per');
            $table->dropColumn('allow_booking_after');
        });
    }
}
