<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCalendarService extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('calendar_services', function (Blueprint $table) {
            $table->id();
            // user_id
            $table->unsignedBigInteger('user_id');
            $table->integer('time_per_slot');
            $table->integer('gap_between_slots');
            // paid by client or self
            $table->string('paid_by');
            // charge decimal
            $table->decimal('charge', 10, 2);
            // price per slot or per month
            $table->string('charge_per');
            // clients per slot
            $table->string('clients_per_slot');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('calendar_services');
    }
}
