<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCategories extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('categories', function (Blueprint $table) {
            $table->id();

            // category_name
            $table->string('category_name')->unique();
            $table->string('category_slug')->unique();
            $table->string('category_image')->nullable();
            $table->string('category_description')->nullable();
            $table->string('category_parent')->nullable();
            $table->string('category_status')->default('active');
            $table->string('category_order')->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('categories');
    }
}
