<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserProfile extends Model
{
    use HasFactory;
    protected $table = 'user_profile';

    // fillable
    protected $fillable = [
        'user_id',
        'city',
        'state'
    ];


    // belongs to user
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    //belongsto city
    public function city()
    {
        return $this->belongsTo(City::class,'city');
    }

    //belongsto State
    public function state(){
        return $this->belongsTo(State::class,'state');
    }
}
