<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ScheduleWorktime extends Model
{
    use HasFactory;
    protected $table = 'schedule_worktime';

    // fillable
    protected $fillable = [
        'schedule_id',
        'start_time',
        'end_time',
        'days'
    ];

    // belongs to service_schedule
    public function service_schedule()
    {
        return $this->belongsTo('App\Models\ServiceSchedule', 'schedule_id', 'id');
    }

    // has many work_slots
    public function work_slots()
    {
        return $this->hasMany('App\Models\WorkSlot', 'worktime_id', 'id');
    }
}
