<?php

use App\Models\Upload;

function get_file_type($extention){
    $type = array(
        "jpg" => "image",
        "jpeg" => "image",
        "png" => "image",
        "svg" => "image",
        "webp" => "image",
        "gif" => "image",
        "mp4" => "video",
        "mpg" => "video",
        "mpeg" => "video",
        "webm" => "video",
        "ogg" => "video",
        "avi" => "video",
        "mov" => "video",
        "flv" => "video",
        "swf" => "video",
        "mkv" => "video",
        "wmv" => "video",
        "wma" => "audio",
        "aac" => "audio",
        "wav" => "audio",
        "mp3" => "audio",
        "zip" => "archive",
        "rar" => "archive",
        "7z" => "archive",
        "doc" => "document",
        "txt" => "document",
        "docx" => "document",
        "pdf" => "document",
        "csv" => "document",
        "xml" => "document",
        "ods" => "document",
        "xlr" => "document",
        "xls" => "document",
        "xlsx" => "document"
    );

    return $type[$extention];
}

function uploaded_asset($id){
    $upload = Upload::find($id);
    if(!empty($upload)){
        $path = public_path('uploads/all/'.$upload->file_name);
        if(file_exists($path)){
            return asset('uploads/all/'.$upload->file_name);
        }else{
            return asset('assets/images/placeholder.jpg');
        }
    }else{
        return asset('assets/images/placeholder.jpg');
    }
}
   