<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\State;
use App\Models\City;
use App\Models\Language;
use App\Models\Category;

class ConfigurationController extends Controller
{
    //

    public function getStates()
    {
        $states = State::all();
        return response()->json($states);
    }

    public function getCities($state_id)
    {
        $cities = City::where('state_id', $state_id)->get();
        return response()->json($cities);
    }

    public function getLanguages()
    {
        $languages = Language::all();
        return response()->json($languages);
    }

    public function getCategories(Request $request)
    {
        $search = $request->search ?? "";
        $parent = $request->parent ?? 0;

        $categories = Category::query();
        if ($search) {
            $categories = $categories->where('category_name', 'like', "%$search%");
        }
        if ($parent) {
            $categories = $categories->where('category_parent', $parent);
        } else {
            $categories = $categories->where('category_parent', NULL);
        }
        $categories->orderBy('category_name','asc');
        $categories = $categories->get();

        return response()->json($categories);
    }
}
